/*
 * Decompiled with CFR 0.152.
 */
package com.lucurious.humandrugkineticswrapper;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.jar.Attributes;

public class JarClassLoader
extends URLClassLoader {
    private final URL url;

    public JarClassLoader(File f) throws MalformedURLException {
        super(new URL[]{f.toURL()});
        this.url = f.toURL();
    }

    public String getMainClassName() throws IOException {
        URL u = new URL("jar", "", this.url + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        Attributes attr = uc.getMainAttributes();
        return attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
    }

    public Object createNewInstance(String name, Object[] constructorArgs) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        Class<?> c = this.loadClass(name);
        Class[] argClasses = null;
        if (constructorArgs != null) {
            argClasses = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                argClasses[i] = constructorArgs[i].getClass();
            }
        }
        Constructor<?> constructor = c.getConstructor(argClasses);
        constructor.setAccessible(true);
        int mods = constructor.getModifiers();
        if (!Modifier.isPublic(mods)) {
            throw new NoSuchMethodException(name + "(" + Arrays.toString(new Class[]{constructorArgs.getClass()}) + ")");
        }
        try {
            return constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public void invokeClass(Object instance, String name, String mainMethod, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = instance == null ? this.loadClass(name) : instance.getClass();
        Class[] argClasses = null;
        if (args != null) {
            argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
        }
        Method m = c.getMethod(mainMethod, argClasses);
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods)) {
            throw new NoSuchMethodException(mainMethod);
        }
        if (!Modifier.isStatic(mods)) {
            try {
                m.invoke(instance, args);
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            try {
                m.invoke(null, args);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

