/*
 * Decompiled with CFR 0.152.
 */
package com.lucurious.humandrugkineticswrapper;

import com.lucurious.humandrugkineticswrapper.JarClassLoader;
import com.lucurious.humandrugkineticswrapper.OSValidator;
import com.lucurious.humandrugkineticswrapper.UpdateManager;
import com.lucurious.humandrugkineticswrapper.Version;
import com.sun.javafx.application.LauncherImpl;
import java.io.File;
import javafx.application.Platform;

public class Main {
    private static File mainFolder;
    private static final String fileName = "HumanDrugKinetics*.jar";
    private static File latestFile;
    private static Version latestVersion;
    private static volatile boolean startedApplication;

    public static void main(String[] args) throws Exception {
        Main.updateLatest();
        UpdateManager updateManager = new UpdateManager();
        updateManager.start();
        Main.runApplication();
    }

    public static void runApplication() throws Exception {
        if (latestFile != null) {
            startedApplication = true;
            JarClassLoader jcl = new JarClassLoader(latestFile);
            LauncherImpl.launchApplication(jcl.loadClass("com.lucurious.humandrugkinetics.Main"), jcl.loadClass("com.lucurious.humandrugkinetics.Preloader"), null);
        }
    }

    public static void updateLatest() {
        File mainFolder = Main.getMainFolder();
        latestVersion = new Version(-1, -1, -1);
        latestFile = null;
        for (File file : mainFolder.listFiles()) {
            String[] array;
            String versionString;
            Version version;
            if (!file.getName().endsWith(".jar") || !file.getName().contains("_") || !(version = Version.fromString(versionString = (array = file.getName().split("_"))[array.length - 1].replace(".jar", ""))).isNewerThan(latestVersion)) continue;
            if (latestFile != null) {
                latestFile.deleteOnExit();
            }
            latestVersion = version;
            latestFile = file;
        }
    }

    public static synchronized File getMainFolder() {
        if (mainFolder == null) {
            switch (OSValidator.getOS()) {
                case "win": {
                    System.out.println("Using Windows");
                    mainFolder = new File(System.getProperty("user.home") + "/.HumanDrugKinetics");
                    break;
                }
                case "osx": {
                    System.out.println("Using OS X :'(");
                    mainFolder = new File(System.getProperty("user.home") + "/Library/Application Support/HumanDrugKinetics/");
                    break;
                }
                case "uni": {
                    System.out.println("Using Unix");
                    mainFolder = new File(System.getProperty("user.home") + "/.HumanDrugKinetics/");
                    break;
                }
                default: {
                    System.out.println("OS wasn't recognized!");
                    mainFolder = new File("HumanDrugKinetics/");
                }
            }
            if (!mainFolder.exists()) {
                mainFolder.mkdir();
            }
        }
        return mainFolder;
    }

    public static String getFileName() {
        return fileName;
    }

    public static void closeApplication() {
        Platform.exit();
        startedApplication = false;
    }

    public static boolean hasStartedApplication() {
        return startedApplication;
    }

    public static File getLatestFile() {
        return latestFile;
    }

    public static Version getLatestVersion() {
        return latestVersion;
    }

    static {
        startedApplication = false;
    }
}

