/*
 * Decompiled with CFR 0.152.
 */
package com.lucurious.humandrugkineticswrapper;

import com.lucurious.humandrugkineticswrapper.Main;
import com.lucurious.humandrugkineticswrapper.Version;
import com.lucurious.humandrugkineticswrapper.packets.Packet;
import com.lucurious.humandrugkineticswrapper.packets.Packet00Version;
import com.lucurious.humandrugkineticswrapper.packets.Packet01Download;
import com.lucurious.humandrugkineticswrapper.packets.Packet03Disconnect;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.Socket;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class UpdateManager
extends Thread {
    private static Version currVersion = new Version(-1, -1, -1);
    private static File versionFile;
    private static int status;
    private JProgressBar downloadProgressBar = null;
    private JLabel downloadProgressLabel = null;
    private JFrame downloadFrame = null;

    @Override
    public void run() {
        versionFile = new File(Main.getMainFolder(), "VERSION");
        currVersion = Main.getLatestVersion();
        Socket socket = null;
        try {
            try {
                socket = new Socket("127.0.0.1", 8999);
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            if (socket == null || !socket.isConnected()) {
                socket = new Socket("server.lucurious.com", 8999);
            }
            socket.setSoTimeout(5000);
        }
        catch (IOException e) {
            System.err.println("Something went wrong whilst opening the socket!");
            e.printStackTrace();
            status = -1;
            UpdateManager.showDialog("Failed to connect to server!", "Failed to connect to server!", "Failed to establish a connection to the server, please ensure you have a working internet connection or try contacting the system administrator (port 8999). Retrieving updates will not be available!", 2);
            return;
        }
        status = 0;
        try {
            DataInputStream dis = new DataInputStream(socket.getInputStream());
            DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
            Packet00Version versionPacket = new Packet00Version();
            dos.write(versionPacket.getPacketSize());
            dos.write(versionPacket.parsePacket());
            boolean running = true;
            block15: while (running) {
                Packet p = this.readPacketFromStream(dis);
                switch (p.getPacketType()) {
                    case VERSION: {
                        Packet01Download downloadPacket;
                        Version serverVersion = ((Packet00Version)p).getVersion();
                        System.out.println("Server is using version " + serverVersion + "!");
                        if (serverVersion.isNewerThan(currVersion)) {
                            System.out.println("We are using version " + currVersion + " so let's update!");
                            downloadPacket = new Packet01Download();
                            dos.write(downloadPacket.getPacketSize());
                            dos.write(downloadPacket.parsePacket());
                            continue block15;
                        }
                        running = false;
                        continue block15;
                    }
                    case DOWNLOAD: {
                        Packet01Download downloadPacket = (Packet01Download)p;
                        this.updateVersion(downloadPacket.getVersion(), downloadPacket.getData());
                        running = false;
                        continue block15;
                    }
                    case DISCONNECT: {
                        running = false;
                        System.out.println("The connection with the server was closed: " + (Object)((Object)((Packet03Disconnect)p).getCause()));
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
                System.err.println("Received an invalid packet from server! Closing connection!");
                running = false;
            }
            Packet03Disconnect disconnectPacket = new Packet03Disconnect();
            disconnectPacket.setCause(Packet03Disconnect.Cause.CLIENT_DISCONNECT);
            dos.write(disconnectPacket.getPacketSize());
            dos.write(disconnectPacket.parsePacket());
            System.out.println("Closing the connection");
        }
        catch (IOException e) {
            System.err.println("Something went wrong whilst communicating with the server!");
            e.printStackTrace();
            return;
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateVersion(Version v, byte[] data) {
        block20: {
            File file = new File(Main.getMainFolder(), Main.getFileName().replace("*", "_" + v));
            File versionFile = new File(Main.getMainFolder(), "VERSION");
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(data);
                fos.flush();
                System.out.println("Successfully updated the current version (" + v + ")!");
                Version oldVersion = v;
                try {
                    BufferedReader br = new BufferedReader(new FileReader(versionFile));
                    oldVersion = Version.fromString(br.readLine());
                    br.close();
                    FileWriter fw = new FileWriter(versionFile, false);
                    PrintWriter pw = new PrintWriter((Writer)fw, false);
                    pw.println(v.toString());
                    pw.flush();
                    pw.close();
                }
                catch (IOException e) {
                    FileWriter fw = new FileWriter(versionFile, false);
                    PrintWriter pw = new PrintWriter((Writer)fw, false);
                    pw.println(oldVersion.toString());
                    pw.flush();
                    pw.close();
                }
            }
            catch (IOException e) {
                System.err.println("An error occurred whilst adding new version '" + v + "' to file '" + file.getName() + "'!");
                if (!file.exists() || file.delete()) break block20;
                file.deleteOnExit();
            }
        }
        if (Main.hasStartedApplication()) {
            UpdateManager.showDialog("Would you like to update?", "A new version has been downloaded and installed (" + v + "), it will be used next time you start the application!", "Newer version available!", 1);
        } else {
            try {
                Main.updateLatest();
                Main.runApplication();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void showDialog(String frameTitle, String msgTitle, String msg, int msgType) throws HeadlessException {
        new Thread(() -> {
            JFrame frame = new JFrame(frameTitle);
            frame.setUndecorated(true);
            frame.setVisible(true);
            frame.setLocationRelativeTo(null);
            frame.setAlwaysOnTop(true);
            JOptionPane.showMessageDialog(frame, msg, msgTitle, msgType);
            frame.dispose();
        }).start();
    }

    private Packet readPacketFromStream(DataInputStream dis) throws IOException {
        byte[] buffer = new byte[4];
        dis.readFully(buffer);
        int packetSize = Packet.getPacketSize(buffer);
        byte[] packetBuffer = new byte[packetSize];
        dis.readFully(packetBuffer, 0, 4);
        Packet.Packets packetType = Packet.Packets.fromByteArray(packetBuffer);
        if (packetType == Packet.Packets.DOWNLOAD && !Main.hasStartedApplication()) {
            this.initDownloadDialog(packetSize);
            int stepSize = (int)Math.ceil((float)(packetSize - 4) / 100.0f);
            int index = 4;
            while (index + stepSize < packetSize) {
                dis.readFully(packetBuffer, index, stepSize);
                this.updateDownloadDialog(index += stepSize, packetSize);
            }
            int remainingBytes = packetSize - index;
            dis.readFully(packetBuffer, index, remainingBytes);
            this.disposeDownloadDialog();
        } else {
            dis.readFully(packetBuffer, 4, packetSize - 4);
        }
        return Packet.parsePacket(packetBuffer);
    }

    private void initDownloadDialog(int totalSize) {
        this.downloadFrame = new JFrame("Downloading...");
        this.downloadFrame.setUndecorated(true);
        this.downloadFrame.setVisible(true);
        this.downloadFrame.setLocationRelativeTo(null);
        this.downloadFrame.setAlwaysOnTop(true);
        JDialog dlg = new JDialog(this.downloadFrame, "Downloading...", true);
        this.downloadProgressBar = new JProgressBar(0, 100);
        dlg.add("Center", this.downloadProgressBar);
        this.downloadProgressLabel = new JLabel("Downloading 0%... (0B / " + this.formatByteCount(totalSize, true) + ")");
        dlg.add("North", this.downloadProgressLabel);
        dlg.setDefaultCloseOperation(0);
        dlg.setSize(300, 75);
        dlg.setLocationRelativeTo(this.downloadFrame);
        new Thread(() -> dlg.setVisible(true)).start();
    }

    private void updateDownloadDialog(int downloadedSize, int totalSize) {
        int progress = downloadedSize * 100 / totalSize;
        this.downloadProgressLabel.setText("Downloading " + progress + "%... (" + this.formatByteCount(downloadedSize, true) + "/" + this.formatByteCount(totalSize, true) + ")");
        this.downloadProgressBar.setValue(progress);
    }

    private void disposeDownloadDialog() {
        this.downloadFrame.dispose();
    }

    private String formatByteCount(int byteCount, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (byteCount < unit) {
            return byteCount + " B";
        }
        int exp = (int)(Math.log(byteCount) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)byteCount / Math.pow(unit, exp), pre);
    }

    private void updateVersionFile(Version version) throws IOException {
        FileWriter fw = new FileWriter(versionFile, false);
        PrintWriter pw = new PrintWriter((Writer)fw, false);
        pw.println(version == null ? "" : version);
        pw.flush();
        pw.close();
        fw.close();
    }

    static {
        status = -2;
    }
}

