/*
 * Decompiled with CFR 0.152.
 */
package com.lucurious.humandrugkineticswrapper;

public class Version {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public static Version fromString(String str) {
        String[] vars = str.split("\\.");
        try {
            return new Version(Integer.valueOf(vars[0]), Integer.valueOf(vars[1]), Integer.valueOf(vars[2]));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        return v.getMajor() == this.getMajor() && v.getMinor() == this.getMinor() && v.getPatch() == this.getPatch();
    }

    public boolean isNewerThan(Version version) {
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMajor() == version.getMajor()) {
            if (this.getMinor() > version.getMinor()) {
                return true;
            }
            if (this.getMinor() == version.getMinor()) {
                return this.getPatch() > version.getPatch();
            }
            return false;
        }
        return false;
    }
}

