/*
 * Decompiled with CFR 0.152.
 */
package com.lucurious.humandrugkineticswrapper.packets;

import com.lucurious.humandrugkineticswrapper.packets.InvalidPacket;
import com.lucurious.humandrugkineticswrapper.packets.Packet00Version;
import com.lucurious.humandrugkineticswrapper.packets.Packet01Download;
import com.lucurious.humandrugkineticswrapper.packets.Packet02Upload;
import com.lucurious.humandrugkineticswrapper.packets.Packet03Disconnect;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class Packet {
    private final Packets packetType;

    public Packet(Packets packetType) {
        this.packetType = packetType;
    }

    public static Packet parsePacket(byte[] data) {
        Packet p = Packets.fromByteArray(data).getNew();
        p.parse(Arrays.copyOfRange(data, 4, data.length));
        return p;
    }

    public byte[] parsePacket() {
        byte[] dataBuffer = this.parse();
        byte[] bufferArray = new byte[4 + dataBuffer.length];
        System.arraycopy(Packet.toByteArray(this.getPacketType().getID()), 0, bufferArray, 0, 4);
        System.arraycopy(dataBuffer, 0, bufferArray, 4, dataBuffer.length);
        return bufferArray;
    }

    protected abstract byte[] parse();

    protected abstract void parse(byte[] var1);

    public Packets getPacketType() {
        return this.packetType;
    }

    public static final int getPacketSize(byte[] data) {
        return Packet.fromByteArray(data);
    }

    protected abstract int getSize();

    public byte[] getPacketSize() {
        return Packet.toByteArray(this.getSize() + 4);
    }

    protected static final byte[] toByteArray(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    protected static final int fromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static enum Packets {
        VERSION(0, Packet00Version.class),
        DOWNLOAD(1, Packet01Download.class),
        UPLOAD(2, Packet02Upload.class),
        DISCONNECT(3, Packet03Disconnect.class),
        INVALID(-1, InvalidPacket.class);

        private final int id;
        private final Class<? extends Packet> packetClass;

        private Packets(int id, Class<? extends Packet> packetClass) {
            this.id = id;
            this.packetClass = packetClass;
        }

        public Packet getNew() {
            try {
                return this.packetClass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Invalid packet: " + this.id + ", " + this.packetClass.getSimpleName());
            }
        }

        public int getID() {
            return this.id;
        }

        public static Packets fromByteArray(byte[] buffer) {
            int id = Packet.fromByteArray(Arrays.copyOfRange(buffer, 0, 4));
            for (Packets packet : Packets.values()) {
                if (packet.getID() != id) continue;
                return packet;
            }
            return INVALID;
        }
    }
}

