/*
 * Decompiled with CFR 0.152.
 */
package com.lucurious.humandrugkineticswrapper.packets;

import com.lucurious.humandrugkineticswrapper.Version;
import com.lucurious.humandrugkineticswrapper.packets.Packet;
import java.util.Arrays;

public class Packet01Download
extends Packet {
    private byte[] data = new byte[0];
    private Version version = new Version(-1, -1, -1);

    public Packet01Download() {
        super(Packet.Packets.DOWNLOAD);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    protected byte[] parse() {
        byte[] major = Packet01Download.toByteArray(this.version.getMajor());
        byte[] minor = Packet01Download.toByteArray(this.version.getMinor());
        byte[] patch = Packet01Download.toByteArray(this.version.getPatch());
        byte[] buffer = new byte[this.data.length + 12];
        System.arraycopy(this.data, 0, buffer, 0, this.data.length);
        System.arraycopy(major, 0, buffer, this.data.length, 4);
        System.arraycopy(minor, 0, buffer, this.data.length + 4, 4);
        System.arraycopy(patch, 0, buffer, this.data.length + 8, 4);
        return buffer;
    }

    @Override
    protected void parse(byte[] data) {
        this.data = Arrays.copyOfRange(data, 0, data.length - 12);
        int major = Packet01Download.fromByteArray(Arrays.copyOfRange(data, this.data.length, this.data.length + 4));
        int minor = Packet01Download.fromByteArray(Arrays.copyOfRange(data, this.data.length + 4, this.data.length + 8));
        int patch = Packet01Download.fromByteArray(Arrays.copyOfRange(data, this.data.length + 8, this.data.length + 12));
        this.version = new Version(major, minor, patch);
    }

    @Override
    protected int getSize() {
        return 12 + this.data.length;
    }
}

