/*
 * Decompiled with CFR 0.152.
 */
package com.lucurious.humandrugkineticswrapper.packets;

import com.lucurious.humandrugkineticswrapper.packets.Packet;
import java.util.Arrays;

public class Packet03Disconnect
extends Packet {
    private Cause cause = Cause.UNKNOWN;

    public Packet03Disconnect() {
        super(Packet.Packets.DISCONNECT);
    }

    @Override
    protected byte[] parse() {
        return Packet03Disconnect.toByteArray(this.cause.getID());
    }

    @Override
    protected void parse(byte[] data) {
        this.cause = Cause.fromByteArray(data);
    }

    @Override
    protected int getSize() {
        return 4;
    }

    public Cause getCause() {
        return this.cause;
    }

    public void setCause(Cause cause) {
        this.cause = cause;
    }

    public static enum Cause {
        CLIENT_DISCONNECT(0),
        SERVER_STOPPING(1),
        TIMEOUT(2),
        CONNECTION_LOST(3),
        UNKNOWN(-1);

        private final int id;

        private Cause(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }

        public static Cause fromByteArray(byte[] array) {
            int id = Packet.fromByteArray(Arrays.copyOfRange(array, 0, 4));
            for (Cause c : Cause.values()) {
                if (id != c.getID()) continue;
                return c;
            }
            return UNKNOWN;
        }
    }
}

